package com.ElyStudio.leGaou.activities;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.ElyStudio.leGaou.R;
import com.ElyStudio.leGaou.adapter.QuizAdapter;
import com.ElyStudio.leGaou.databinding.ActivityAllQuizBinding;
import com.ElyStudio.leGaou.models.GetQuiz;
import com.ElyStudio.leGaou.models.Quiz;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.Constants;
import com.ElyStudio.leGaou.utilities.GridViewSpacing;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;

import java.util.List;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AllQuizActivity extends AppCompat {

    ActivityAllQuizBinding binding;
    RecyclerView quizRecyclerView;
    public static final String TAG = "ALL_QUIZ_ACTIVITY";
    int userCoins,watchEarnReward;
    int adEnabled;
    String nativeAdId,interstitialAdId,rewardedAdId;
    BottomSheetDialog noInternetBottomSheet,errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityAllQuizBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());
    }

    @Override
    protected void onStart() {
        super.onStart();
        getQuiz();
    }

    void getQuiz(){

        int categoryId = getIntent().getIntExtra(Constants.categoryId,0);
        userCoins = getIntent().getIntExtra(Constants.userCoins,0);
        watchEarnReward = getIntent().getIntExtra(Constants.watchEarnReward,0);

        if(categoryId != 0)
        {
            String title = getIntent().getStringExtra(Constants.categoryTitle);
            binding.heading.setText(title);
        }
        if(CheckInternetConnection.isInternetConnected(AllQuizActivity.this))
        {
            Call<GetQuiz> getQuizCall = ApiController.getInstance().getApi().getQuiz(categoryId);
            getQuizCall.enqueue(new Callback<GetQuiz>() {
                @Override
                public void onResponse(Call<GetQuiz> call, Response<GetQuiz> response) {
                    if(response.body().getStatusCode() == 0)
                    {
                        if(response.body().getQuizList() != null )
                        {
                            setQuizRecyclerView(response.body().getQuizList());
                        }
                    }
                    else if(response.body().getStatusCode() == 1)
                    {
                        binding.quizRecyclerView.setVisibility(View.GONE);
                        binding.heading.setVisibility(View.GONE);
                        binding.noQuizHeading.setVisibility(View.VISIBLE);
                        binding.emptyIllustration.setVisibility(View.VISIBLE);

                    }
                }

                @Override
                public void onFailure(Call<GetQuiz> call, Throwable t) {
                    showErrorOccurredBottomSheet();
                    Log.d(TAG,"getQuizCall Failure = "+t.getLocalizedMessage());
                }
            });
        }
        else
        {
            showNoInternetBottomSheet();
        }


    }
    void setQuizRecyclerView(List<Quiz> quizList){

        adEnabled = getIntent().getIntExtra(Constants.adEnabled,0);
        nativeAdId = getIntent().getStringExtra(Constants.nativeAdId);
        interstitialAdId = getIntent().getStringExtra(Constants.interstitialAdId);
        rewardedAdId = getIntent().getStringExtra(Constants.rewardedAdId);

        quizRecyclerView = binding.quizRecyclerView;
        RecyclerView.LayoutManager layoutManager = new GridLayoutManager(AllQuizActivity.this,2,RecyclerView.VERTICAL,false);
        QuizAdapter adapter = new QuizAdapter(AllQuizActivity.this,quizList,AllQuizActivity.this,binding.getRoot(),userCoins,watchEarnReward,adEnabled,nativeAdId,interstitialAdId,rewardedAdId);
        quizRecyclerView.addItemDecoration(new GridViewSpacing(2,40,false));
        quizRecyclerView.setLayoutManager(layoutManager);
        quizRecyclerView.setAdapter(adapter);
    }

    public void showNoInternetBottomSheet(){

        noInternetBottomSheet = new BottomSheetDialog(AllQuizActivity.this);
        View view = LayoutInflater.from(AllQuizActivity.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        noInternetBottomSheet.setContentView(view);

        Button contactSupportBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = noInternetBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = noInternetBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = noInternetBottomSheet.findViewById(R.id.bottomSheetTitle);
        noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = noInternetBottomSheet.findViewById(R.id.bottomSheetSubText);
        contactSupportBtn.setVisibility(View.GONE);

        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(CheckInternetConnection.isInternetConnected(AllQuizActivity.this))
                {
                    noInternetBottomSheet.cancel();
                    getQuiz();
                }
                else
                {
                    QuizzeSnackBar.showSnackBar(AllQuizActivity.this,view,getResources().getString(R.string.no_internet),getResources().getColor(R.color.error));
                }
            }
        });

        bottomSheetTitle.setText(getResources().getString(R.string.no_internet));
        bottomSheetSubText.setText(getResources().getString(R.string.no_internet_sub_text));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(AllQuizActivity.this,R.drawable.no_conection_illustration));

        if(!AllQuizActivity.this.isFinishing())
        {
            noInternetBottomSheet.show();
        }

    }

    public void showErrorOccurredBottomSheet(){

        errorOccurredBottomSheet = new BottomSheetDialog(AllQuizActivity.this);
        View view = LayoutInflater.from(AllQuizActivity.this).inflate(R.layout.error_occurred_bottom_sheet,findViewById(R.id.errorOccurredBottomSheetLayout),false);
        errorOccurredBottomSheet.setContentView(view);
        errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSecondaryButton);
        Button tryAgainBtn = errorOccurredBottomSheet.findViewById(R.id.bottomSheetPrimaryButton);
        ImageView bottomSheetIllustration = errorOccurredBottomSheet.findViewById(R.id.bottomSheetIllustraton);
        TextView bottomSheetTitle = errorOccurredBottomSheet.findViewById(R.id.bottomSheetTitle);
        TextView bottomSheetSubText = errorOccurredBottomSheet.findViewById(R.id.bottomSheetSubText);

        bottomSheetTitle.setText(getResources().getString(R.string.some_error_occurred));
        bottomSheetSubText.setText(getResources().getString(R.string.error_subtext));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable(AllQuizActivity.this,R.drawable.error_illustration));
        contactSupportBtn.setText(getResources().getString(R.string.contact_support));
        tryAgainBtn.setText(getResources().getString(R.string.try_again));

        contactSupportBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(AllQuizActivity.this, SupportScreen.class));
            }
        });

        tryAgainBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                errorOccurredBottomSheet.cancel();
                getQuiz();
            }
        });

        if(!AllQuizActivity.this.isFinishing())
        {
            errorOccurredBottomSheet.show();
        }
    }
}